/*
 * Decompiled with CFR 0.152.
 */
package rbasamoyai.createbigcannons.utils;

import com.mojang.brigadier.StringReader;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.serialization.Codec;
import java.util.Arrays;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.commands.arguments.blocks.BlockStateParser;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.HolderLookup;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.ExtraCodecs;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;
import org.joml.Matrix3f;
import org.joml.Matrix3fc;
import org.joml.Matrix4f;
import org.joml.Matrix4fc;
import rbasamoyai.createbigcannons.multiloader.NetworkPlatform;
import rbasamoyai.createbigcannons.network.ClientboundBlastSoundPacket;
import rbasamoyai.createbigcannons.network.ClientboundSendCustomBreakProgressPacket;
import rbasamoyai.createbigcannons.utils.CBCRegistryUtils;

public class CBCUtils {
    private static final Map<String, SoundSource> SOURCE_BY_NAME = Arrays.stream(SoundSource.values()).collect(Collectors.toMap(SoundSource::m_12676_, Function.identity()));
    public static final Codec<SoundSource> SOUND_SOURCE_CODEC = CBCUtils.fromEnumWithStringFunction(SoundSource::values, SoundSource::m_12676_, CBCUtils::soundSourceFromName);

    @Nullable
    public static SoundSource soundSourceFromName(String name) {
        return SOURCE_BY_NAME.get(name);
    }

    public static Set<String> getSoundSourceNames() {
        return SOURCE_BY_NAME.keySet();
    }

    public static ResourceLocation location(String namespace, String path) {
        return new ResourceLocation(namespace, path);
    }

    public static ResourceLocation location(String location) {
        return new ResourceLocation(location);
    }

    public static Matrix3f mat3x3f(float m00, float m01, float m02, float m10, float m11, float m12, float m20, float m21, float m22) {
        return new Matrix3f(m00, m01, m02, m10, m11, m12, m20, m21, m22);
    }

    public static Matrix4f mat4x4f(float m00, float m01, float m02, float m03, float m10, float m11, float m12, float m13, float m20, float m21, float m22, float m23, float m30, float m31, float m32, float m33) {
        return new Matrix4f(m00, m01, m02, m03, m10, m11, m12, m13, m20, m21, m22, m23, m30, m31, m32, m33);
    }

    public static Matrix4f mat4x4f(@Nonnull Matrix3f mat3x3f) {
        return CBCUtils.mat4x4f(mat3x3f.m00, mat3x3f.m01, mat3x3f.m02, 0.0f, mat3x3f.m10, mat3x3f.m11, mat3x3f.m12, 0.0f, mat3x3f.m20, mat3x3f.m21, mat3x3f.m22, 0.0f, 0.0f, 0.0f, 0.0f, 1.0f);
    }

    public static Matrix3f mat3x3fFacing(Vec3 normalized) {
        float cx = (float)(-normalized.f_82480_);
        float cy = (float)normalized.f_82479_;
        float cos = (float)(-normalized.f_82481_);
        float k = 1.0f / (1.0f + cos);
        if (Float.isFinite(k)) {
            return CBCUtils.mat3x3f(cx * cx * k + cos, cy * cx * k, cy, cx * cy * k, cy * cy * k + cos, -cx, -cy, cx, cos);
        }
        return CBCUtils.mat3x3f(1.0f, 0.0f, 0.0f, 0.0f, -1.0f, 0.0f, 0.0f, 0.0f, -1.0f);
    }

    public static Matrix3fc mat3x3fFacing(Vec3 dest, Vec3 source) {
        Vec3 c = source.m_82537_(dest);
        float cx = (float)c.f_82479_;
        float cy = (float)c.f_82480_;
        float cz = (float)c.f_82481_;
        float cos = (float)(-source.m_82526_(dest));
        float k = 1.0f / (1.0f + cos);
        if (Float.isFinite(k)) {
            return CBCUtils.mat3x3f(cx * cx * k + cos, cy * cx * k - cz, cz * cx * k + cy, cx * cy * k + cz, cy * cy * k + cos, cz * cy * k - cx, cx * cz * k - cy, cy * cz * k + cx, cz * cz * k + cos);
        }
        Vec3 vec3 = new Vec3(0.0, 0.0, 1.0);
        if (Math.abs(1.0 - source.m_82526_(vec3)) < 1.0E-4) {
            return CBCUtils.mat3x3f(1.0f, 0.0f, 0.0f, 0.0f, -1.0f, 0.0f, 0.0f, 0.0f, -1.0f);
        }
        Matrix3f first = CBCUtils.mat3x3fFacing(source);
        first.transpose(first);
        Matrix3f second = CBCUtils.mat3x3fFacing(dest);
        second.mul((Matrix3fc)first, second);
        return second;
    }

    public static Matrix4f mat4x4fFacing(Vec3 normalized) {
        float cx = (float)(-normalized.f_82480_);
        float cy = (float)normalized.f_82479_;
        float cos = (float)(-normalized.f_82481_);
        float k = 1.0f / (1.0f + cos);
        if (Float.isFinite(k)) {
            return CBCUtils.mat4x4f(cx * cx * k + cos, cy * cx * k, cy, 0.0f, cx * cy * k, cy * cy * k + cos, -cx, 0.0f, -cy, cx, cos, 0.0f, 0.0f, 0.0f, 0.0f, 1.0f);
        }
        return CBCUtils.mat4x4f(1.0f, 0.0f, 0.0f, 0.0f, 0.0f, -1.0f, 0.0f, 0.0f, 0.0f, 0.0f, -1.0f, 0.0f, 0.0f, 0.0f, 0.0f, 1.0f);
    }

    public static Matrix4f mat4x4fFacing(Vec3 dest, Vec3 source) {
        Vec3 c = source.m_82537_(dest);
        float cx = (float)c.f_82479_;
        float cy = (float)c.f_82480_;
        float cz = (float)c.f_82481_;
        float cos = (float)(-source.m_82526_(dest));
        float k = 1.0f / (1.0f + cos);
        if (Float.isFinite(k)) {
            return CBCUtils.mat4x4f(cx * cx * k + cos, cy * cx * k - cz, cz * cx * k + cy, 0.0f, cx * cy * k + cz, cy * cy * k + cos, cz * cy * k - cx, 0.0f, cx * cz * k - cy, cy * cz * k + cx, cz * cz * k + cos, 0.0f, 0.0f, 0.0f, 0.0f, 1.0f);
        }
        Vec3 vec3 = new Vec3(0.0, 0.0, 1.0);
        if (Math.abs(1.0 - source.m_82526_(vec3)) < 1.0E-4) {
            return CBCUtils.mat4x4f(1.0f, 0.0f, 0.0f, 0.0f, 0.0f, -1.0f, 0.0f, 0.0f, 0.0f, 0.0f, -1.0f, 0.0f, 0.0f, 0.0f, 0.0f, 1.0f);
        }
        Matrix4f first = CBCUtils.mat4x4fFacing(source);
        Matrix4f firstD = new Matrix4f();
        first.transpose(firstD);
        Matrix4f second = CBCUtils.mat4x4fFacing(dest);
        Matrix4f result = new Matrix4f();
        second.mul((Matrix4fc)first, result);
        return result;
    }

    public static void sendCustomBlockDamage(Level level, BlockPos pos, int damage) {
        if (!(level instanceof ServerLevel)) {
            return;
        }
        ServerLevel slevel = (ServerLevel)level;
        ClientboundSendCustomBreakProgressPacket pkt = new ClientboundSendCustomBreakProgressPacket(pos, damage);
        for (ServerPlayer splayer : slevel.m_6907_()) {
            double f;
            double e;
            double d = (double)pos.m_123341_() - splayer.m_20185_();
            if (!(d * d + (e = (double)pos.m_123342_() - splayer.m_20186_()) * e + (f = (double)pos.m_123343_() - splayer.m_20189_()) * f < 1024.0)) continue;
            NetworkPlatform.sendToClientPlayer(pkt, splayer);
        }
    }

    public static Vec3 getSurfaceNormalVector(Level level, BlockPos hitPos, Vec3 normal) {
        return normal;
    }

    public static Vec3 getSurfaceNormalVector(Level level, BlockHitResult hitResult) {
        Direction dir = hitResult.m_82434_();
        return CBCUtils.getSurfaceNormalVector(level, hitResult.m_82425_(), new Vec3((double)dir.m_122429_(), (double)dir.m_122430_(), (double)dir.m_122431_()));
    }

    public static void playBlastLikeSoundOnServer(ServerLevel level, double x, double y, double z, SoundEvent soundEvent, SoundSource soundSource, float volume, float pitch, float airAbsorption) {
        double radius = volume > 1.0f ? (double)(16.0f * volume) : 16.0;
        double radSqr = radius * radius;
        ClientboundBlastSoundPacket packet = new ClientboundBlastSoundPacket(soundEvent, soundSource, x, y, z, volume, pitch, airAbsorption);
        for (ServerPlayer player : level.m_6907_()) {
            if (!(player.m_20275_(x, y, z) < radSqr)) continue;
            NetworkPlatform.sendToClientPlayer(packet, player);
        }
    }

    public static <E extends Enum<E>> Codec<E> fromEnumWithStringFunction(Supplier<E[]> elementSupplier, Function<E, String> strFunc, Function<String, E> namingFunction) {
        Enum[] enums = (Enum[])elementSupplier.get();
        return ExtraCodecs.m_184425_((Codec)ExtraCodecs.m_184405_(strFunc, namingFunction), (Codec)ExtraCodecs.m_184421_(Enum::ordinal, i -> i >= 0 && i < enums.length ? enums[i] : null, (int)-1));
    }

    public static BlockState parseBlockState(StringReader reader) throws CommandSyntaxException {
        return BlockStateParser.m_234691_((HolderLookup)CBCRegistryUtils.getBlockRegistry().m_255303_(), (StringReader)reader, (boolean)false).f_234748_();
    }

    private CBCUtils() {
    }
}

